/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.objects;

import jpcsp.Emulator;
import jpcsp.GUI.UmdVideoPlayer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXArray;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXBoolean;
import jpcsp.format.rco.vsmx.interpreter.VSMXFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNull;
import jpcsp.format.rco.vsmx.interpreter.VSMXString;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import org.apache.log4j.Logger;

public class Controller
extends BaseNativeObject {
    private static final Logger log = VSMX.log;
    public static final String objectName = "controller";
    private VSMXBaseObject userData;
    private String resource;
    private BasePositionObject focus;
    private VSMXInterpreter interpreter;
    private UmdVideoPlayer umdVideoPlayer;

    public static VSMXNativeObject create(VSMXInterpreter interpreter, UmdVideoPlayer umdVideoPlayer, String resource) {
        Controller controller = new Controller(interpreter, umdVideoPlayer);
        VSMXNativeObject object = new VSMXNativeObject(interpreter, controller);
        controller.setObject(object);
        controller.resource = resource;
        object.setPropertyValue("onChangeResource", (VSMXBaseObject)VSMXNull.singleton);
        object.setPropertyValue("onMenu", (VSMXBaseObject)VSMXNull.singleton);
        object.setPropertyValue("onExit", (VSMXBaseObject)VSMXNull.singleton);
        object.setPropertyValue("onAutoPlay", (VSMXBaseObject)VSMXNull.singleton);
        object.setPropertyValue("onContinuePlay", (VSMXBaseObject)VSMXNull.singleton);
        return object;
    }

    private Controller(VSMXInterpreter interpreter, UmdVideoPlayer umdVideoPlayer) {
        this.interpreter = interpreter;
        this.umdVideoPlayer = umdVideoPlayer;
        this.userData = new VSMXArray(interpreter);
    }

    public VSMXInterpreter getInterpreter() {
        return this.interpreter;
    }

    public VSMXBaseObject getUserData(VSMXBaseObject object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.getUserData() returning %s", this.userData));
        }
        return this.userData;
    }

    public VSMXBaseObject setUserData(VSMXBaseObject object, VSMXBaseObject userData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.setUserData(%s)", userData));
        }
        this.userData = userData;
        return VSMXBoolean.singletonTrue;
    }

    public String getResource() {
        return this.resource;
    }

    public VSMXBaseObject changeResource(VSMXBaseObject object, VSMXBaseObject resource) {
        String newResource;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.changeResource(%s)", resource));
        }
        if (!this.resource.equals(newResource = resource.getStringValue())) {
            ChangeResourceAction action = new ChangeResourceAction(newResource);
            Emulator.getScheduler().addAction(action);
        }
        return VSMXBoolean.singletonTrue;
    }

    public void setFocus(BasePositionObject newFocus) {
        if (this.focus != null) {
            this.focus.focusOut();
        }
        this.focus = newFocus;
        this.umdVideoPlayer.getRCODisplay().setFocus(newFocus);
    }

    public void onUp() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.onUp focus=%s", this.focus));
        }
        if (this.focus != null) {
            this.focus.onUp();
        }
    }

    public void onDown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.onDown focus=%s", this.focus));
        }
        if (this.focus != null) {
            this.focus.onDown();
        }
    }

    public void onLeft() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.onLeft focus=%s", this.focus));
        }
        if (this.focus != null) {
            this.focus.onLeft();
        }
    }

    public void onRight() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.onRight focus=%s", this.focus));
        }
        if (this.focus != null) {
            this.focus.onRight();
        }
    }

    public void onPush() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Controller.onPush focus=%s", this.focus));
        }
        if (this.focus != null) {
            this.focus.onPush();
        }
    }

    private class ChangeResourceAction
    implements IAction {
        private String newResource;

        public ChangeResourceAction(String newResource) {
            this.newResource = newResource;
        }

        @Override
        public void execute() {
            Controller.this.resource = this.newResource;
            Controller.this.umdVideoPlayer.changeResource(Controller.this.resource);
            VSMXBaseObject callback = Controller.this.getObject().getPropertyValue("onChangeResource");
            if (callback instanceof VSMXFunction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Executing Controller.onChangeResource '%s' with function %s", Controller.this.resource, callback));
                }
                VSMXBaseObject[] arguments = new VSMXBaseObject[]{new VSMXString(Controller.this.interpreter, Controller.this.resource)};
                Controller.this.interpreter.delayInterpretFunction((VSMXFunction)callback, null, arguments);
            }
        }
    }
}

